#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdlib.h>

//  
#define F_CPU 16000000UL 		        //    (16 MHz)
#define INCDIRECTION		YDIR	    //   XDIR (), YDIR ()
#include "proc.h"						//  
#include "adjectives.h"					//  
#include "keyboard.h"					// 
#include "lcd.h"						//  +   (, , )
#include "draw_spr.h"					//  
#include "chr.h"						//  
#include "sdcard.h"						//   SD 





void draw_score(unsigned char score)
{
 	

  char text[] = "0000000  ";

  for(unsigned char i=6; i>0; i--)
  {
    text[i] = 0x30 + score % 10;
    score/=10;
  }
  rectangle8(17,87,18,132,0x0A);
  put_string8(17,87,text,0xFF,0x0A);

}

void main()
{
unsigned char f[]="upload.bat";
unsigned char f1[]="mos";

unsigned char r;
keyboard_init(); 
lcd_init(0x0A);
sdcard_init();

while (1){

r=PINC;
if (r==127) 
{
	savechar (f,f1);
	lcd_free();
	boot_start();

}




draw_score(r);
}

}
